/* Tombstone task
Churches will unlock the cemetery building
Once Cemetery building is placed task is marked as available.  
Each unit that dies after that will mount a tombstone prop at one of the buildings mount points.
*/

// Check for Cemetery building
function Tombstone_cemetery::onExit()
{
   TaskModifier.strMarkVertex("TombstoneTask", "Tombstone_cemetery", $TSV_CMPLETE);
   TaskModifier.strMarkVertex("TombstoneTask", "Tombstone_goodsheriff", $TSV_AVAIL);
   TaskModifier.strMarkVertex("TombstoneTask", "Tombstone_badsheriff", $TSV_AVAIL);
   TaskModifier.strMarkVertex("TombstoneTask", "Tombstone_deputy", $TSV_AVAIL);
   TaskModifier.strMarkVertex("TombstoneTask", "Tombstone_malegun", $TSV_AVAIL);
   TaskModifier.strMarkVertex("TombstoneTask", "Tombstone_femalegun", $TSV_AVAIL);
   TaskModifier.strMarkVertex("TombstoneTask", "Tombstone_toughgun", $TSV_AVAIL);
   TaskModifier.strMarkVertex("TombstoneTask", "Tombstone_nicegun", $TSV_AVAIL);
}
function Tombstone_deputy::onExit()
{
   //deput dies
   %timer = new SLTimer()
   {
      time = 0;
   };
   %timer.notifyOnFire(spawnTombstone, %timer);
   %timer.type = "Tombstone_deputy";
}
function Tombstone_malegun::onExit()
{
   //male gunslinger dies
   %timer = new SLTimer()
   {
      time = 0;
   };
   %timer.notifyOnFire(spawnTombstone, %timer);
   %timer.type = "Tombstone_malegun";
}
function Tombstone_femalegun::onExit()
{
   //female gunslinger dies
   %timer = new SLTimer()
   {
      time = 0;
   };
   %timer.notifyOnFire(spawnTombstone, %timer);
   %timer.type = "Tombstone_femalegun";
}
function Tombstone_goodsheriff::onExit()
{
   //good sheriff dies
   %timer = new SLTimer()
   {
      time = 0;
   };
   %timer.notifyOnFire(spawnTombstone, %timer);
   %timer.type = "Tombstone_goodsheriff";
}
function Tombstone_badsheriff::onExit()
{
   //bad sheriff dies
   %timer = new SLTimer()
   {
      time = 0;
   };
   %timer.notifyOnFire(spawnTombstone, %timer);
   %timer.type = "Tombstone_badsheriff";
}
function Tombstone_nicegun::onExit()
{
   //nice gunslinger dies
   %timer = new SLTimer()
   {
      time = 0;
   };
   %timer.notifyOnFire(spawnTombstone, %timer);
   %timer.type = "Tombstone_nicegun";
}
function Tombstone_toughgun::onExit()
{
   //tough gunslinger dies
   %timer = new SLTimer()
   {
      time = 0;
   };
   %timer.notifyOnFire(spawnTombstone, %timer);
   %timer.type = "Tombstone_toughgun";
}
// Adds tombstone mountimages to cemetery
function SLTimer::spawnTombstone(%timer) 
{
   %objList = tsCreateObjList();
   tsFindObjTypeOnMap("cemetery", "bldg", %objList);
   for(%index = 0; %index < %objList.getSize(); %index++)
   {
      %object = %objList.getID(%index);
      if(%object.getTeam() == "1")
      {
         if(%object.getMountedImage(7) == 0)
         {
            %cemeteryID = %object;
            break;
         }
      }
   }
   tsDestroyObjList(%objList); // Destroy object list
   for(%count = 0; %count < 8; %count++)
   {
      if(%cemeteryID.getMountedImage(%count) $= 0)
      {
         tsMountImageOnObj(%cemeteryID, "Tombstone"@%count);
         break;
      }
   }
   TaskModifier.strResetVertex("TombstoneTask", %timer.type);
   TaskModifier.strMarkVertex("TombstoneTask", %timer.type, $TSV_AVAIL);
}
